/*
 * @(#)ZipAbout.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import com.sun.java.swing.JDialog;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JPanel;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.Dimension;
import java.awt.Point;

import java.io.File;


/**
 * Class used to display the about program
 * @see ZipButton
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class ZipAbout extends JDialog {


    /**
     * Class constructor
     * @param owner the frame instanciating the dialog
     * @param title the title of the dialog
     */
    public ZipAbout(Frame owner, String title) {
	super(owner,title,true);

	// get the owner location
	Dimension dim = owner.getSize();
	Point loc = owner.getLocation();
	
	// set the about dialog
	ZipButton okButton = new ZipButton("Ok","images" + File.separator + "about.gif");
	JPanel panel = new JPanel();
	ButtonListener listener = new ButtonListener(this);

	okButton.addActionListener(listener);

	panel.add(okButton);
	panel.setLayout(new FlowLayout(FlowLayout.CENTER));

	getContentPane().add("Center",panel);
	pack();

	// set the location of the dialog, in the middle of the owner
	Dimension curdim = getSize();
	setLocation(loc.x + dim.width/2 - curdim.width/2, loc.y + dim.height/2 - curdim.height/2);
	setVisible(true);
    }
    

    /**
     * Class used to listen to the action button
     * @version 1.0
     * @author Frank Moisant - Patrick Titiano
     */
    private class ButtonListener implements ActionListener {

	// private member
	private ZipAbout zipAbout;
	
	/**
	 * Class constructor
	 * @param zipAbout the dialog to listen to
	 */
	public ButtonListener(ZipAbout zipAbout) {
	    super();
	    this.zipAbout = zipAbout;
	}

	/**
	 * Called when an action is performed
	 * @param e the action event
	 */
	public void actionPerformed(ActionEvent e) {
	    String command = e.getActionCommand();
	    if(command.equals("Ok")) {
		zipAbout.dispose();
	    }
	}
    }

    /**
     * Return if the dialog can be resized
     * @return always false
     */
    public boolean isResizable() {
	return false;
    }


}
